<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToPlansTable extends Migration
{
    public function up()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->integer('Quota_Limit')->default(0)->after('Duration');
            $table->enum('Status', ['active', 'inactive', 'archived'])->default('active')->after('Quota_Limit');
            $table->text('Description')->nullable()->after('Status');
        });
    }

    public function down()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn(['Quota_Limit', 'Status', 'Description']);
        });
    }
}
